const express = require("express");
const dotenv = require("dotenv");
const cors = require("cors");

const appRoutes = require("./routers/app.routes");
const authRouter = require("./routers/auth.routes");
const userRouter = require("./routers/user.routes");
const authorize = require("./middlewares/authorize");

dotenv.config();

const app = express();

app.use(cors());

app.use(express.urlencoded({ extended: false }));
app.use(express.json());


app.use(express.static("public"));

app.use(appRoutes);
app.use(authRouter);
app.use(authorize, userRouter);

app.use((err, req, res, next) => {
  console.error(err.stack);
  res.status(500).json({ message: err.message });
});

const port = process.env.PORT || 3000;

app.listen(port, () => {
  console.log(`🚀 Server running on port ${port}`);
});
