const client = require("../config/db");
const {
  storiesQuery,
  slidersQuery,
  gamesQuery,
  searchUsersQuery,
  userByIdQuery,
  searchSessionsQuery,
  searchTeamsQuery,
  getTeamByIdQuery,
  getSessionByIdQuery,
} = require("../services/queries/app.query");

const getStories = async (req, res) => {
  try {
    const { rows } = await client.query(storiesQuery);
    return res.json({ rows });
  } catch (error) {
    return res.status(500).json({ message: error.message });
  }
};

const getSliders = async (req, res) => {
  try {
    const { rows } = await client.query(slidersQuery);
    return res.json({ sliders: rows });
  } catch (error) {
    return res.status(500).json({ message: error.message });
  }
};

const getGames = async (req, res) => {
  try {
    const { rows } = await client.query(gamesQuery);
    return res.json({ rows });
  } catch (error) {
    return res.status(500).json({ message: error.message });
  }
};

const searchUsers = async (req, res) => {
  try {
    const { q, page = 1 } = req.query;

    if (!q || q.trim() === "") {
      return res
        .status(400)
        .json({ message: "لطفاً عبارت جستجو را وارد کنید" });
    }

    const value = `%${q}%`;
    const offset = (page - 1) * 10;

    const { rows } = await client.query(searchUsersQuery, [value, offset]);

    return res.json({ rows });
  } catch (error) {
    return res.status(500).json({ message: error.message });
  }
};

const getUserById = async (req, res) => {
  try {
    const { id } = req.params;
    const { rows } = await client.query(userByIdQuery, [id]);
    return res.json({ rows });
  } catch (error) {
    return res.status(500).json({ message: error.message });
  }
};

const searchSessions = async (req, res) => {
  try {
    const { q } = req.query;

    if (!q || q.trim() === "") {
      return res
        .status(400)
        .json({ message: "لطفاً عبارت جستجو را وارد کنید" });
    }

    const value = `%${q}%`;
    const { rows } = await client.query(searchSessionsQuery, [value]);

    return res.json({ sessions: rows });
  } catch (error) {
    return res.status(500).json({ message: error.message });
  }
};

const searchTeams = async (req, res) => {
  try {
    const { q } = req.query;

    if (!q || q.trim() === "") {
      return res
        .status(400)
        .json({ message: "لطفاً عبارت جستجو را وارد کنید" });
    }

    const value = `%${q}%`;
    const { rows } = await client.query(searchTeamsQuery, [value]);

    return res.json({ rows });
  } catch (error) {
    return res.status(500).json({ message: error.message });
  }
};

const getTeamById = async (req, res) => {
  try {
    const { id } = req.params;
    const { rows } = await client.query(getTeamByIdQuery, [id]);
    return res.json({ rows });
  } catch (error) {
    return res.status(500).json({ message: error.message });
  }
};

const getSessionById = async (req, res) => {
  try {
    const { id } = req.params;
    const { rows } = await client.query(getSessionByIdQuery, [id]);
    return res.json({ rows });
  } catch (error) {
    return res.status(500).json({ message: error.message });
  }
};

module.exports = {
  getStories,
  getSliders,
  getGames,
  searchUsers,
  getUserById,
  searchSessions,
  searchTeams,
  getTeamById,
  getSessionById,
};
