const otpService = require("../services/auth/otp.service");
const smsService = require("../services/sms/sms.service");
const userService = require("../services/user.service");
const tokenService = require("../services/token.service");


async function sendOtp(req, res) {
  try {
    const { phone } = req.body;

    if (!phone) {
      return res.status(400).json({ message: "phone is required" });
    }

    const otp = otpService.generateOtp();

    await otpService.saveOtp(phone, otp);
    smsService.sendSms(phone, `کد ورود شما: ${otp}`);

    return res.status(200).json({ message: "OTP sent" });
  } catch (error) {
    console.log(error);
    return res.status(500).json({ message: "server error" });
  }
}

async function verifyOtp(req, res) {
  try {
    const { phone, code } = req.body;

    if (!phone || !code) {
      return res.status(400).json({
        message: "phone and code are required",
      });
    }

    const otpRecord = await otpService.verifyOtp(phone, code);

    if (!otpRecord) {
      return res.status(400).json({
        message: "OTP is invalid or expired",
      });
    }

    let user = await userService.findByPhone(phone);
    let isNewUser = false;

    if (!user) {
      user = await userService.create(phone); // ✅ اصلاح
      isNewUser = true;
    }

    const token = tokenService.generateToken({
      id: user.id,
      phone: user.phone,
    });

    return res.status(200).json({
      message: "OTP verified successfully",
      token,
      isNewUser,
    });
  } catch (error) {
    return res.status(500).json({ message: "server error" });
  }
}




module.exports = {
  sendOtp,
  verifyOtp,
};




