const {
  follow,
  checkFollow,
  unfollow,
  checkFavoriteGame,
  addFavoriteGame,
  deleteFavoriteGame,
} = require("../services/user.service");

async function followController(req, res) {
  try {
    if (!req.body) {
      throw new Error("no body");
    }
    const { following_id } = req.body;
    if (!following_id) {
      res.status(400);
      return res.json({ message: "no following id" });
    }
    if (!req.user) {
      throw new Error();
    }
    const followObject = await checkFollow(req.user.id, following_id);
    if (followObject) {
      res.status(400);
      return res.json({ message: "follow is already happened" });
    }
    await follow(req.user.id, following_id);
    res.status(201);
    return res.json({ message: "done" });
  } catch (error) {
    return res.status(500).json({ message: "server error" });
  }
}

async function unfollowController(req, res) {
  try {
    if (!req.body) {
      throw new Error("no body");
    }
    const { following_id } = req.body;
    if (!following_id) {
      res.status(400);
      return res.json({ message: "no following id" });
    }
    if (!req.user) {
      throw new Error();
    }
    const followObject = await checkFollow(req.user.id, following_id);
    if (followObject) {
      await unfollow(req.user.id, following_id);
      res.status(200);
      return res.json({ message: "done" });
    } else {
      res.status(400);
      return res.json({ message: "you do not have this user followed" });
    }
  } catch (error) {
    return res.status(500).json({ message: "server error" });
  }
}

async function addFavoriteGameController(req, res) {
  try {
    if (!req.body) {
      throw new Error("no body");
    }

    const { gameId } = req.body;

    if (!gameId) {
      res.status(400);
      return res.json({ message: "no game id" });
    }

    const isFav = await checkFavoriteGame(req.user.id, gameId);

    if (isFav) {
      res.status(400);
      return res.json({ message: "favorite already exists" });
    }

    await addFavoriteGame(req.user.id, gameId);

    res.status(201);
    return res.json({ message: "done" });
  } catch (error) {
    console.log(error);
    return res.status(500).json({ message: "server error" });
  }
}

async function deleteFavoriteGameController(req, res) {
  try {
    if (!req.body) {
      throw new Error("no body");
    }

    const { gameId } = req.body;

    if (!gameId) {
      res.status(400);
      return res.json({ message: "no game id" });
    }

    const isFav = await checkFavoriteGame(req.user.id, gameId);

    if (isFav) {
      await deleteFavoriteGame(req.user.id, gameId);
      res.status(200);
    } else {
      res.status(400);
      return res.json({ message: "you do not have this game favorited" });
    }

    return res.json({ message: "done" });
  } catch (error) {
    console.log(error);
    return res.status(500).json({ message: "server error" });
  }
}

module.exports = {
  followController,
  unfollowController,
  addFavoriteGameController,
  deleteFavoriteGameController,
};
