const express = require("express");

const {
  getStories,
  getSliders,
  getGames,
  searchUsers,
  getUserById,
  searchSessions,
  searchTeams,
  getTeamById,
  getSessionById,
} = require("../controllers/app.controller");

const router = express.Router();

router.get("/stories", getStories);

router.get("/sliders", getSliders);

router.get("/games", getGames);

router.get("/users/search", searchUsers);

router.get("/users/:id", getUserById);

router.get("/sessions/search", searchSessions);

router.get("/teams/search", searchTeams);

router.get("/teams/:id", getTeamById);

router.get("/sessions/:id", getSessionById);

module.exports = router;
