// const otpStore = new Map();

// function generateOtp() {
//   return String(Math.floor(100000 + Math.random() * 900000));
// }

// function saveOtp(phone, code) {
//   otpStore.set(phone, {
//     code,
//     expiresAt: Date.now() + 2 * 60 * 1000,
//   });
// }

// function verifyOtp(phone, code) {
//   const data = otpStore.get(phone);
//   if (!data) return false;

//   const { expiresAt, code: savedCode } = data;

//   if (Date.now() > expiresAt) {
//     otpStore.delete(phone);
//     return false;
//   }

//   if (savedCode !== code) return false;

//   otpStore.delete(phone);
//   return true;
// }

// module.exports = {
//   generateOtp,
//   saveOtp,
//   verifyOtp,
// };


const db = require("../../config/db");
const {
  SAVE_OTP,
  VERIFY_OTP,
} = require("../queries/auth.query"); // ✅ مسیر اصلاح‌شده

// ===== Generate OTP =====
function generateOtp() {
  return String(Math.floor(100000 + Math.random() * 900000));
}

// ===== Save OTP =====
async function saveOtp(phone, code) {
  // اطمینان حاصل کنید که SAVE_OTP یک کوئری SQL برای ذخیره OTP در دیتابیس است.
  // مثال: INSERT INTO otps (phone, code, expires_at) VALUES ($1, $2, NOW() + INTERVAL '2 minutes');
  await db.query(SAVE_OTP, [phone, code]);
}

// ===== Verify OTP =====
async function verifyOtp(phone, code) {
  // اطمینان حاصل کنید که VERIFY_OTP یک کوئری SQL برای بررسی OTP و انقضای آن است.
  // مثال: SELECT * FROM otps WHERE phone = $1 AND code = $2 AND expires_at > NOW();
  const { rows } = await db.query(VERIFY_OTP, [phone, code]);
  return rows[0]; // اگر نباشه ⇒ undefined
}

module.exports = {
  generateOtp,
  saveOtp,
  verifyOtp,
};
