const storiesQuery = `
select 
  gs.*,
  g.name as gym_name,
  (array_agg(gi.img))[1] as image
from gyms_stories gs
left join gyms g on gs.gym_id = g.id
left join gyms_images gi on gi.gym_id = g.id
where 
  gs.created_at >= now() - interval '1 day'
  and gs.deleted_at is null
group by gs.id, g.name
`;

const slidersQuery = `
select s.*, g.name as gym_name
from sliders s
left join gyms g on s.gym_id = g.id WHERE s.deleted_at IS NULL
`;

const gamesQuery = `
select * from games
`;

const searchUsersQuery = `
select 
  u.id,
  u.name,
  u.family,
  u.username,
  u.email,
  u.phone,
  u.profile
from users u
where
  u.name ILIKE $1 OR
  u.family ILIKE $1 OR
  u.username ILIKE $1 OR
  u.email ILIKE $1
order by u.id asc
offset $2
limit 10
`;

const userByIdQuery = `
select 
  u.*,
  (
    select array_agg(
      json_build_object(
        'id', g.id,
        'name', g.name,
        'icon', g.icon
      )
    )
    from favorites fav
    left join games g on g.id = fav.game_id
    where fav.user_id = u.id
  ) as favorites,
  sum((f.following_id = u.id)::int) as followers_count,
  sum((f.follower_id = u.id)::int) as followings_count
from users u
left join follows f 
  on f.follower_id = u.id or f.following_id = u.id
where u.id = $1
group by u.id
`;

const searchSessionsQuery = `
select 
  s.id as session_id,
  s.name as session_name,
  s.price,
  s.gender,
  gyms.id as gym_id,
  gyms.name as gym_name,
  games.id as game_id,
  games.name as game_name,
  sub_games.id as sub_game_id,
  sub_games.name as sub_game_name,
  locations.address,
  neighborhoods.name as neighborhood_name,
  cities.name as city_name,
  provinces.name as province_name,
  (select array_agg(json_build_object('start',stwd.start_time,'end',stwd.end_time)) from sessions_to_week_days stwd where stwd.session_id=s.id) as times
from sessions s
left join sub_games on s.sub_game_id = sub_games.id
left join games on sub_games.game_id = games.id
left join gyms on s.gym_id = gyms.id
left join locations on locations.gym_id = gyms.id
left join neighborhoods on locations.neighborhood_id = neighborhoods.id
left join cities on neighborhoods.city_id = cities.id
left join provinces on cities.province_id = provinces.id
where
  s.name ILIKE $1 OR
  games.name ILIKE $1 OR
  sub_games.name ILIKE $1 OR
  gyms.name ILIKE $1 OR
  neighborhoods.name ILIKE $1 OR
  cities.name ILIKE $1 OR
  provinces.name ILIKE $1 OR
  locations.address ILIKE $1
order by s.id asc
`;

const searchTeamsQuery = `
select id, name
from teams
where name ILIKE $1
order by id asc
`;

const getTeamByIdQuery = `
select 
  t.*,
  count(tr.user_id) as members_count
from teams t
left join teams_requests tr on tr.team_id = t.id
where t.id = $1
group by t.id
`;

const getSessionByIdQuery = `
select *
from sessions
where id = $1
`;

// queries/app.query.js

// ===== USER =====
const FIND_USER_BY_PHONE = `
  SELECT * FROM users
  WHERE phone = $1
  LIMIT 1
`;

const CREATE_USER = `
  INSERT INTO users (phone,created_at)
  VALUES ($1,now())
  RETURNING *
`;

module.exports = {
  storiesQuery,
  slidersQuery,
  gamesQuery,
  searchUsersQuery,
  userByIdQuery,
  searchSessionsQuery,
  searchTeamsQuery,
  getTeamByIdQuery,
  getSessionByIdQuery,
  FIND_USER_BY_PHONE,
  CREATE_USER,
};
