const FOLLOW = `
  INSERT INTO follows(follower_id,following_id,created_at) values($1,$2,now())
`;

const UNFOLLOW = `
  UPDATE follows SET deleted_at=now() WHERE follower_id=$1 AND following_id=$2 AND deleted_at IS NULL)
`;

const CHECK_FOLLOW = `
SELECT * FROM follows WHERE follower_id=$1 AND following_id=$2 AND deleted_at IS NULL
`;

const CHECK_FAVORITE_GAME = `
SELECT * FROM favorites WHERE user_id=$1 AND game_id=$2 AND deleted_at IS NULL
`;

const ADD_FAVORITE_GAME = `
INSERT INTO favorites(user_id,game_id,created_at) values($1,$2,now())
`;

const DELETE_FAVORITE_GAME = `
UPDATE favorites SET deleted_at=now() WHERE user_id=$1 AND game_id=$2
`;

module.exports = {
  FOLLOW,
  UNFOLLOW,
  CHECK_FOLLOW,
  CHECK_FAVORITE_GAME,
  ADD_FAVORITE_GAME,
  DELETE_FAVORITE_GAME,
};
