const db = require("../config/db");
const {
  FIND_USER_BY_PHONE,
  CREATE_USER,
} = require("../services/queries/app.query");
const {
  FOLLOW,
  CHECK_FOLLOW,
  UNFOLLOW,
  CHECK_FAVORITE_GAME,
  ADD_FAVORITE_GAME,
  DELETE_FAVORITE_GAME,
} = require("./queries/user.query");

async function findByPhone(phone) {
  const { rows } = await db.query(FIND_USER_BY_PHONE, [phone]);
  return rows[0];
}

async function create(phone) {
  const { rows } = await db.query(CREATE_USER, [phone]);
  return rows[0];
}

async function checkFollow(followerId, followingId) {
  const { rows } = await db.query(CHECK_FOLLOW, [followerId, followingId]);
  return rows[0];
}

async function follow(followerId, followingId) {
  const { rows } = await db.query(FOLLOW, [followerId, followingId]);
  return rows[0];
}

async function unfollow(followerId, followingId) {
  const { rows } = await db.query(UNFOLLOW, [followerId, followingId]);
  return rows[0];
}

async function checkFavoriteGame(userId, gameId) {
  const { rows } = await db.query(CHECK_FAVORITE_GAME, [userId, gameId]);
  return rows[0];
}

async function addFavoriteGame(userId, gameId) {
  const { rows } = await db.query(ADD_FAVORITE_GAME, [userId, gameId]);
  return rows[0];
}

async function deleteFavoriteGame(userId, gameId) {
  const { rows } = await db.query(DELETE_FAVORITE_GAME, [userId, gameId]);
  return rows[0];
}

module.exports = {
  findByPhone,
  create,
  checkFollow,
  follow,
  unfollow,
  checkFavoriteGame,
  addFavoriteGame,
  deleteFavoriteGame,
};
